/**
* \file: challenge.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: authorization level daemon
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef ALD_MODEL_CHALLENGE_H
#define ALD_MODEL_CHALLENGE_H


#include <stdbool.h>
#include <stdint.h>

#include "ald_types.h"

/**
 * creates a new challenge. This functions overrides / invalidates the current one.
 * @ecu_id the ecu id used to create the challenge
 */
void challenge_create_new(const char *ecu_id);

/**
 * Invalidates the current challenge
 */
void challenge_invalidate(void);

/**
 * \brief returns the currently set challenge.
 * If no valid challenge is set at the time of the call, NULL is returned.
 * \return the currently set challenge or NULL if none is set
 */
const challenge_t *challenge_get_current(void);

/**
 * \brief validates the challenge response.
 * \param response a challenge response data structure used to request a level change
 * \return returns RESULT_OK, if the given challenge response fits to the currently set challenge
 */
error_code_t challenge_validate_response(const challenge_response_t *response);

/**
 * seeds the random number generator
 */
void challenge_seed_random_number_generator(void);

/**
 * returns true if the current challenge is valid
 * @return true, if the current challenge is valid
 */
bool challenge_is_valid(void);

#endif
